<x-app-layout>

    @section('title')
        {{ __('translation.Marks Report By Class') }}
    @endsection

    @push('top_css')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

 @endpush


<style type="text/css">
.select2-container {
}

.select2-results__option {
  padding-right: 20px;
  vertical-align: middle;
}
.select2-results__option:before {
  content: "";
  display: inline-block;
  position: relative;
  height: 20px;
  width: 20px;
  border: 2px solid #e9e9e9;
  border-radius: 4px;
  background-color: #fff;
  margin-right: 20px;
  vertical-align: middle;
}
.select2-results__option[aria-selected=true]:before {
  font-family:fontAwesome;
  content: "\f00c";
  color: #fff;
  background-color: #f77750;
  border: 0;
  display: inline-block;
  padding-left: 3px;
}
.select2-container--default .select2-results__option[aria-selected=true] {
	background-color: #fff;
}
.select2-container--default .select2-results__option--highlighted[aria-selected] {
	background-color: #eaeaeb;
	color: #272727;
}
.select2-container--default .select2-selection--multiple {
	margin-bottom: 10px;
}
.select2-container--default.select2-container--open.select2-container--below .select2-selection--multiple {
	border-radius: 4px;
}
.select2-container--default.select2-container--focus .select2-selection--multiple {
	border-color: #007bff;
	border-width: 2px;
}
.select2-container--default .select2-selection--multiple {
	border-width: 2px;
}
.select2-container--open .select2-dropdown--below {

	border-radius: 6px;
	box-shadow: 0 0 10px rgba(0,0,0,0.5);

}
.select2-selection .select2-selection--multiple:after {
	content: 'hhghgh';
}
/* select with icons badges single*/
.select-icon .select2-selection__placeholder .badge {
	display: none;
}
.select-icon .placeholder {
	display: none;
}
.select-icon .select2-results__option:before,
.select-icon .select2-results__option[aria-selected=true]:before {
	display: none !important;
	/* content: "" !important; */
}
.select-icon  .select2-search--dropdown {
	display: none;
}

.select2-container .select2-search--inline .select2-search__field {
    box-sizing: border-box;
    border: none;
    font-size: 100%;
    margin-top: 9px !important;
    margin-left: 5px;
    vertical-align: bottom;
    font-family: unset !important;
}

</style>
    <div class="col-span-12">
        <x-card.card-default>
            <x-card.header>
                <x-card.title>
                    {{ __('translation.Seat Plan By Class ') }}
                </x-card.title>
            </x-card.header>
            <x-card.body>
            <div class="mt-6">
        @if (session('success'))
            <x-alert-success>
                {{ session('success') }}
            </x-alert-success>
        @endif

        @if (session('danger'))
            <x-alert-danger>
                {{ session('danger') }}
            </x-alert-danger>
        @endif

        @if (session('error'))
            <x-alert-danger>
                {{ session('error') }}
            </x-alert-danger>
        @endif
    </div>
                <form method="POST" action="{{route('PDF_export_seat_plan')}}" id="form-import" enctype="multipart/form-data">
                @csrf
				<div class="mb-8 md:mb-2">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div class="w-full md:w-full lg:w-full xl:w-full flex flex-col sm:flex-row mb-0 sm:mb-4">

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="exam_id" id="__selectExamFilter" class="exam_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Exam') . ' -' }}
                                    </option>
                                    @if (isset($exams))
                                        @foreach ($exams as $exam)
                                            <option value="{{$exam->id}}">{{$exam->exam_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="class_id" id="__selectClassFilter" class="class_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Class') . ' -' }}
                                    </option>
                                    @if (isset($classes))
                                        @foreach ($classes as $classe)
                                            <option value="{{$classe->id}}">{{$classe->class_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="section_id" id="__selectSectionFilter" class="section_id" style="width: 100%;">
                                    <option value="0" disabled>
                                        {{ '- ' . __('translation.Select Section') . ' -' }}
                                    </option>
                                    @if (isset($sections))
                                        @foreach ($sections as $section)
                                            <option value="{{$section->id}}">{{$section->section_name}}</option>
                                        @endforeach
                                    @endif

                                </x-select>
                            </div>

                            <div class="w-full lg:w-2/5 mb-4 sm:mb-0 sm:ml-2">
                                <x-select name="session_id" id="__selectSessionFilter" class="session_id" style="width: 100%;">
                                    <option value="" selected disabled>
                                        {{ '- ' . __('translation.Select Session') . ' -' }}
                                    </option>
                                    @if (isset($sessions))
                                        @foreach ($sessions as $session)
                                            <option value="{{$session->id}}">{{$session->session_name}}</option>
                                        @endforeach
                                    @endif
                                </x-select>
                            </div>
                        </div>
                    </div>
                </div>

				<div class="mb-8 md:mb-2">
                    <div class="flex flex-col md:flex-row items-center justify-between">
                        <div class="w-full md:w-full lg:w-full xl:w-full flex flex-col sm:flex-row mb-0 sm:mb-4">

                            <div class="w-full md:w-1/4 lg:w-1/3 xl:w-1/2 flex items-center justify-end lg:justify-start lg:ml-2 mt-2">
                            <x-button type="button" color="blue" class="relative -top-1 order-last md:order-first mx-1" id="__btnSubmitFilter">
                                {{ __('translation.Search') }}
                            </x-button>
                            <x-button type="button" color="yellow" class="ml-1 relative -top-1 reset-filter" id="__btnResetFilter">
                                {{ __('translation.Reset') }}
                            </x-button>

                            <x-button type="submit" color="green" class="ml-2 relative -top-1 reset-filter" id="__btnExcelExport">
                                {{ __('translation.PDF EXPORT') }}
                            </x-button>
							</div>

                        </div>
                    </div>
                </div>

				</form>

                <div class="overflow-x-auto">
                    <table class="w-full" id="datatable">
                        <thead>
                            <tr>
                                <th class="text-center">ID</th>
                                <th class="text-left">Student Name</th>
                                <th class="text-center">Roll No</th>
                                <th class="text-center">Class</th>
                                <th class="text-center">Section</th>
                                <th class="text-center">Session</th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </x-card.body>
        </x-card.card-default>
    </div>


    <x-modal.modal-large class="modal-excel modal-hide">
        <x-modal.header>
            <x-modal.title>
                Marks Sheet Excel Export
            </x-modal.title>
            <x-modal.close-button id="closeModalproduct" />
        </x-modal.header>
        <x-modal.body>
        <div id="excel-wrapper"></div>
        </x-modal.body>
    </x-modal.modal-large>


    @push('bottom_js')
        <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
        <script>
            const dataTabletUrl = '{{ route('seat_plans_datatable_by_class') }}';
            const excelExportUrl = '{{ route('PDF_export_seat_plan') }}';

            const loadMarksBySubjectDataTable = (examId,classId,sectionId, sessionId,subjectId) => {

                $('#datatable').DataTable({
                    processing: true,
                    serverSide: true,
                    bDestroy: true,
                    ajax: {
                        type: 'GET',
                        url: dataTabletUrl,
                        data: {
                            examId: examId,
                            classId: classId,
                            sectionId: sectionId,
                            sessionId: sessionId,
                            subjectId: subjectId
                        },
                        dataSrc: function ( json ) {
                            return json.data;
                        }
                    },


                    columns: [
                        {
                            name: 'id',
                            data: 'id'
                        },
                        {
                            name: 'name',
                            data: 'name'
                        },
                        {
                            name: 'roll_no',
                            data: 'roll_no'
                        },
                        {
                            name: 'class_name',
                            data: 'class_name'
                        },
                        {
                            name: 'section_name',
                            data: 'section_name'
                        },
                        {
                            name: 'session_name',
                            data: 'session_name'
                        }
                    ],
                    columnDefs: [
                        {
                            targets: [0],
                            visible: false
                        },
                        {
                            targets: [1, 4],
                            orderable: false
                        },
                        {
                            targets: [0,2,3,4,5],
                            className: 'text-center'
                        },
                        { "width": "33%", "targets": 1 },
                    ],
                    paginationType: 'numbers'
                });
            }

            let examId = $('#__selectExamFilter').val();
            let classId = $('#__selectClassFilter').val();
            let sectionId = $('#__selectSectionFilter').val();
            let sessionId = $('#__selectSessionFilter').val();
            let subjectId = $('#__selectSubjectFilter').val();

            let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
            let fullmarks = $("#fullmarks").val();

            if(classId==null){ classId=0; }
            if(sectionId==null){ sectionId=0; }
            if(sessionId==null){ sessionId=0; }
            if(subjectId==null){ subjectId=0; }


            loadMarksBySubjectDataTable(examId,classId,sectionId, sessionId,subjectId);


            $(document).ready(function() {

                $('#__selectExamFilter').select2({
                    placeholder: '- Select Exam -',
                    allowClear: true
                });

                $('#__selectSectionFilter').select2({
                    placeholder: '- Select Section -',
                    allowClear: true
                });

                $('#__selectClassFilter').select2({
                    placeholder: '- Select Class -',
                    allowClear: true
                });

                $('#__selectSessionFilter').select2({
                    placeholder: '- Select Session -',
                    allowClear: true
                });

                $('#__selectSubjectFilter').select2({
                    placeholder: '- Select Subject -',
                    allowClear: true
                });


                $('#__selectIsFourthSubjectFilter').select2({
                    placeholder: '- Select Subject Type -',
                    allowClear: false
                });


                $('#__selectExamFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
            });


            $('#__btnSubmitFilter').click(function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }



                loadMarksBySubjectDataTable(examId,classId,sectionId,sessionId,subjectId);

            });

            // Handle to Reset Dropdown,Input fields
            $('#__btnResetFilter').on('click',function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                let excelSearch = $("input[type='search']").val();

                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }

                loadMarksBySubjectDataTable(examId,classId,sectionId, sessionId,subjectId);

                $('#__selectExamFilter').val('').trigger('change');
                $('#__selectSectionFilter').val('').trigger('change');
                $('#__selectClassFilter').val('').trigger('change');
                $('#__selectSessionFilter').val('').trigger('change');
                $('#__selectSubjectFilter').val('').trigger('change');
            });


           // Handle to Export as a excel file
            $(document).on('click', '#__btnExcelExport111', function() {
                let examId = $('#__selectExamFilter').val();
                let classId = $('#__selectClassFilter').val();
                let sectionId = $('#__selectSectionFilter').val();
                let sessionId = $('#__selectSessionFilter').val();
                let subjectId = $('#__selectSubjectFilter').val();
                let isFourthSubject = $('#__selectIsFourthSubjectFilter').val();
                let fullmarks = $("#fullmarks").val();
                let excelSearch = $("input[type='search']").val();

                if(classId==null){ classId=0; }
                if(sectionId==null){ sectionId=0; }
                if(sessionId==null){ sessionId=0; }
                if(subjectId==null){ subjectId=0; }


                $.ajax({
                       type: 'POST',
                        url: excelExportUrl,
                        data: {
                            excel: 1,
                            excelSearch : excelSearch,
                            examId : examId,
                            classId : classId,
                            sectionId : sectionId,
                            sessionId : sessionId,
                            subjectId : subjectId
                        },
                    beforeSend: function() {
                       // $('#excel-wrapper').html('processing...');
                       // $('.modal-excel').removeClass('modal-hide');
                    }
                }).done(function(result) {
                   // console.log(result);
                    let downloadLink = '<a href="'+result+'" download >Download Now</a>';
                    $('#excel-wrapper').html(downloadLink);
                });
            });




            $('#closeModalproduct').click(function() {
                $('.modal-excel').addClass('modal-hide');
                $('body').removeClass('modal-open');
            });

        </script>
    @endpush

</x-app-layout>
